VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "RockmagStep"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
'local variable(s) to hold property value(s)
Private mvarLevel As Double 'local copy
Private mvarBiasField As Double 'local copy
Private mvarStepType As String 'local copy
Private mvarSpinSpeed As Single 'local copy
Private mvarHoldTime As Single 'local copy
Public Measure As Boolean
Public MeasureSusceptibility As Boolean
Private mvarRemarks As String ' (November 2007 L Carporzen) Remarks column in RMG
Private mvarKey As String
Private Const RockmagStepAFmax = "AFmax"
Private Const RockmagStepAFz = "AFz"
Private Const RockmagStepAF = "AF"
Private Const RockmagStepUAFX1 = "UAFX1"
Private Const RockmagStepUAFX2 = "UAFX2"
Private Const RockmagStepUAFZ = "UAFZ"
Private Const RockmagStepARM = "ARM"
Private Const RockmagStepPulseIRM = "IRM"
Private Const RockmagStepRRM = "RRM"
Private Const RockmagStepRRMz = "RRMz"

Public Sub PerformStep(specimen As Sample)
    Dim SampleCenterRMPosition As Long
    If Prog_halted Then Exit Sub
    If ARMMax > 0 Then frmIRMARM.SetBiasField 0
    If Not ((mvarStepType = RockmagStepAF) Or (mvarStepType = RockmagStepARM) _
        Or (mvarStepType = RockmagStepPulseIRM) Or (mvarStepType = RockmagStepRRM) Or _
        (mvarStepType = RockmagStepUAFX1) Or (mvarStepType = RockmagStepUAFX2) Or (mvarStepType = RockmagStepUAFZ) Or _
        (mvarStepType = RockmagStepAFmax) Or (mvarStepType = RockmagStepAFz)) Then _
        Exit Sub
    If specimen.Parent.doBoth And Not specimen.Parent.doUp Then Exit Sub
    SampleCenterRMPosition = Int(AFPos + SampleHeight / 2)
    If mvarStepType = RockmagStepPulseIRM Then
        frmDCMotors.UpDownMove 0, 1
    Else
        MotorUpDn_Move SampleCenterRMPosition, 1 '  Move somewhat slowly into AF region
    End If
    frmDCMotors.TurningMotorRotate 0
    If EnableARM And mvarBiasField > 0 And ((mvarStepType = RockmagStepARM) Or (mvarStepType = RockmagStepRRM) Or (mvarStepType = RockmagStepRRMz)) Then
        frmIRMARM.SetBiasField BiasField
    End If
    Select Case mvarStepType
        Case RockmagStepAF
            If level > 0 And EnableAF Then
                frmAF.Connect
                frmAF.CycleWithHold HoldTime, TransverseCoilSystem, level, AFRampRate
                frmDCMotors.TurningMotorRotate 90
                If Not frmAF.txtWaitingTime = 0 Then DelayTime (frmAF.txtWaitingTime) ' (August 2007 L Carporzen) Allow to wait between each ramp
                frmAF.CycleWithHold HoldTime, TransverseCoilSystem, level, AFRampRate
                If Not frmAF.txtWaitingTime = 0 Then DelayTime (frmAF.txtWaitingTime) ' (August 2007 L Carporzen) Allow to wait between each ramp
                frmAF.CycleWithHold HoldTime, AxialCoilSystem, level, AFRampRate
                frmAF.Disconnect
                frmDCMotors.TurningMotorRotate 360
            End If
        Case RockmagStepAFmax
            If level > 0 And EnableAF Then
                frmAF.Connect
                frmAF.CycleWithHold HoldTime, TransverseCoilSystem, AfTransMax, AFRampRate
                frmDCMotors.TurningMotorRotate 90
                If Not frmAF.txtWaitingTime = 0 Then DelayTime (frmAF.txtWaitingTime) ' (August 2007 L Carporzen) Allow to wait between each ramp
                frmAF.CycleWithHold HoldTime, TransverseCoilSystem, AfTransMax, AFRampRate
                If Not frmAF.txtWaitingTime = 0 Then DelayTime (frmAF.txtWaitingTime) ' (August 2007 L Carporzen) Allow to wait between each ramp
                frmAF.CycleWithHold HoldTime, AxialCoilSystem, AfAxialMax, AFRampRate
                frmAF.Disconnect
                frmDCMotors.TurningMotorRotate 360
            End If
        Case RockmagStepAFz
            If level > 0 And EnableAF Then
                frmAF.Connect
                frmAF.CycleWithHold HoldTime, AxialCoilSystem, level, AFRampRate
                frmAF.Disconnect
            End If
        Case RockmagStepUAFX1
            If level > 0 And EnableAF Then
                frmAF.Connect
                frmAF.CycleWithHold HoldTime, TransverseCoilSystem, level, AFRampRate
                frmAF.Disconnect
            End If
        Case RockmagStepUAFX2
            If level > 0 And EnableAF Then
                frmAF.Connect
                frmDCMotors.TurningMotorRotate 90
                frmAF.CycleWithHold HoldTime, TransverseCoilSystem, level, AFRampRate
                frmAF.Disconnect
                frmDCMotors.TurningMotorRotate 360
            End If
        Case RockmagStepUAFZ
            If level > 0 And EnableAF Then
                frmAF.Connect
                frmAF.CycleWithHold HoldTime, AxialCoilSystem, level, AFRampRate
                frmAF.Disconnect
            End If
        Case RockmagStepARM
            If level > 0 And EnableARM Then
                frmAF.Connect
                frmAF.CycleWithHold HoldTime, AxialCoilSystem, level, AFRampRate
                frmAF.Disconnect
            Else
                DelayTime HoldTime
            End If
        Case RockmagStepPulseIRM
            If EnableIRM Then
                SampleCenterRMPosition = Int(frmIRMARM.IRMCenteringPos(level) + SampleHeight / 2)
                ' discharge with sample in load position
                MotorUpDn_Move 0, 1
                frmIRMARM.FireIRM 0
                DelayTime 1
                frmIRMARM.FireIRM 0
                MotorUpDn_Move SampleCenterRMPosition, 1
                If Abs(level) > 0 Then frmIRMARM.FireIRMAtField level
            End If
        Case RockmagStepRRM
            If EnableAF Then
                frmDCMotors.TurningMotorSpin SpinSpeed, 300 + HoldTime
                If level > 0 And COMPortAf > 0 Then
                    frmAF.Connect
                    frmAF.CycleWithHold HoldTime, TransverseCoilSystem, level, AFRampRate
                    frmAF.Disconnect
                End If
                frmDCMotors.TurningMotorSpin 0
            End If
        Case RockmagStepRRMz
            If EnableAF Then
                frmDCMotors.TurningMotorSpin SpinSpeed, 300 + HoldTime
                If level > 0 And COMPortAf > 0 Then
                    frmAF.Connect
                    frmAF.CycleWithHold HoldTime, AxialCoilSystem, level, AFRampRate
                    frmAF.Disconnect
                End If
                frmDCMotors.TurningMotorSpin 0
            End If
    End Select
    If mvarBiasField > 0 Then
        frmIRMARM.SetBiasField 0
    End If
End Sub

Public Property Let key(ByVal vdata As String)
    mvarKey = vdata
End Property

Public Property Get key() As String
    key = mvarKey
End Property

Public Property Let HoldTime(ByVal vdata As Single)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.HoldTime = 5
    mvarHoldTime = vdata
End Property

Public Property Get HoldTime() As Single
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.HoldTime
    If mvarHoldTime > 0 Then
        HoldTime = mvarHoldTime
    Else
        HoldTime = 0
    End If
End Property

Public Property Let SpinSpeed(ByVal vdata As Single)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.SpinSpeed = 5
    mvarSpinSpeed = vdata
End Property

Public Property Get SpinSpeed() As Single
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.SpinSpeed
    If mvarSpinSpeed > 40 Then
        SpinSpeed = 40
    ElseIf mvarSpinSpeed < -40 Then
        SpinSpeed = -40
    Else
        SpinSpeed = mvarSpinSpeed
    End If
End Property

Public Property Let StepType(ByVal vdata As String)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.StepType = "AF"
    mvarStepType = vdata
End Property

Public Property Get StepType() As String
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.StepType
    StepType = mvarStepType
End Property

Public Property Get DemagStepLabel() As String
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.DemagStepType
    Dim numLength As Integer
    Dim i As Integer
    Dim setLevel As Long
    DemagStepLabel = StepType
    If Len(DemagStepLabel) > DEMAGLEN Then DemagStepLabel = Left$(DemagStepLabel, DEMAGLEN)
    numLength = DEMAGLEN - Len(DemagStepLabel)
    If StepType = RockmagStepARM Then setLevel = BiasField Else setLevel = level
    DemagStepLabel = DemagStepLabel & Right$(Format$(Format$(setLevel, "######"), "@@@@@@"), numLength)
    If Len(DemagStepLabel) < DEMAGLEN Then
        For i = Len(DemagStepLabel) + 1 To DEMAGLEN
            DemagStepLabel = DemagStepLabel & " "
        Next i
    End If
End Property

Public Property Get DemagStepLabelLong() As String
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.DemagStepType
    Dim setLevel As Long
    DemagStepLabelLong = StepType
    If StepType = RockmagStepARM Then setLevel = BiasField Else setLevel = level
    DemagStepLabelLong = DemagStepLabelLong & " " & Str$(setLevel)
    If StepType = RockmagStepRRM Then DemagStepLabelLong = DemagStepLabelLong & "/" & SpinSpeed & " rps"
End Property

Public Property Let BiasField(ByVal vdata As Double)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.BiasField = 5
        mvarBiasField = vdata
End Property

Public Property Get BiasField() As Double
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.BiasField
    If Not EnableARM Then
        BiasField = 0
    ElseIf mvarBiasField > ARMMax Then
        BiasField = ARMMax
    ElseIf mvarBiasField < 0 Then
        BiasField = 0
    Else
        BiasField = mvarBiasField
    End If
End Property

Public Property Let level(ByVal vdata As Double)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.Level = 5
    mvarLevel = vdata
End Property

Public Property Get level() As Double
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.Level
    Dim maxAcceptableLevel As Long
    Dim minAcceptableLevel As Long
    Select Case mvarStepType
        Case RockmagStepAF
            If AfAxialMax > AfTransMax Then maxAcceptableLevel = AfTransMax Else maxAcceptableLevel = AfAxialMax
            If AfAxialMin < AfTransMin Then minAcceptableLevel = AfAxialMin Else minAcceptableLevel = AfTransMin
            If Not EnableAF Then maxAcceptableLevel = 0
        Case RockmagStepAFmax
            If AfAxialMax > AfTransMax Then maxAcceptableLevel = AfTransMax Else maxAcceptableLevel = AfAxialMax
            If AfAxialMin < AfTransMin Then minAcceptableLevel = AfAxialMin Else minAcceptableLevel = AfTransMin
            If Not EnableAF Then maxAcceptableLevel = 0
        Case RockmagStepAFz
            maxAcceptableLevel = AfAxialMax
            minAcceptableLevel = AfAxialMin
            If Not EnableAF Then maxAcceptableLevel = 0
        Case RockmagStepUAFX1
            maxAcceptableLevel = AfTransMax
            minAcceptableLevel = AfTransMin
            If Not EnableAF Then maxAcceptableLevel = 0
        Case RockmagStepUAFX2
            maxAcceptableLevel = AfTransMax
            minAcceptableLevel = AfTransMin
            If Not EnableAF Then maxAcceptableLevel = 0
        Case RockmagStepUAFZ
            maxAcceptableLevel = AfAxialMax
            minAcceptableLevel = AfAxialMin
            If Not EnableAF Then maxAcceptableLevel = 0
        Case RockmagStepARM
            maxAcceptableLevel = AfAxialMax
            minAcceptableLevel = AfAxialMin
            If Not EnableARM Then maxAcceptableLevel = 0
        Case RockmagStepPulseIRM
            If PulseHFMax > PulseLFMax Then maxAcceptableLevel = PulseHFMax Else maxAcceptableLevel = PulseLFMax
            If EnableIRMBackfield Then minAcceptableLevel = -PulseLFMax Else minAcceptableLevel = PulseLFMin
            
            If Not EnableIRM Then
                maxAcceptableLevel = 0
                minAcceptableLevel = 0
            End If
        Case RockmagStepRRM
            maxAcceptableLevel = AfTransMax
            minAcceptableLevel = AfTransMin
            If Not EnableAF Then maxAcceptableLevel = 0
        Case Else
            maxAcceptableLevel = 999999
            minAcceptableLevel = -999999
    End Select
    If StepType = RockmagStepAFmax Then
        level = maxAcceptableLevel
    ElseIf mvarLevel = 0 Then
        level = 0
    ElseIf mvarLevel > maxAcceptableLevel Then
        level = maxAcceptableLevel
    ElseIf mvarLevel < minAcceptableLevel Then
        level = minAcceptableLevel
    Else
        level = mvarLevel
    End If
End Property

Public Property Let Remarks(ByVal vdata As String)
    mvarRemarks = vdata ' (November 2007 L Carporzen) Remarks column in RMG
End Property

Public Property Get Remarks() As String
    Remarks = mvarRemarks ' (November 2007 L Carporzen) Remarks column in RMG
End Property
